#!/bin/bash
set -e # exit on error

DATASET="unk_vqa_validated"
MODEL_PATH=$1
if [ -z "$2" ]; then
    overwrite=False
else
    overwrite=$2
fi

bash scripts/v1_5/eval/unk_vqa_validated.sh $MODEL_PATH $overwrite

pred_data=$(AZFUSE_USE_FUSE=1 python llava/eval/utils.py check_output_file_exists --output_file ${MODEL_PATH}/${DATASET}/merge.jsonl)

echo "pred_data: ${pred_data}"

question_file=<DATA_FOLDER>/vqav2/vqa_k_test_noun_dedup_sampled_1_sft_llaval_idk.human_valid_rewrite.eval.jsonl
image_folder="<DATA_FOLDER>/lama-gpt4v_gen_q/"

MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
    echo "qwen-vl in model path"

else
    
    python_cmd="python -m llava.eval.get_vqa_pred_prob_only_yes_or_no --model-path ${MODEL_PATH} --question-file ${question_file} --pred-file ${pred_data} --image-folder ${image_folder} --answers-file ${MODEL_PATH}/${DATASET}/pred_probs_only_yes_or_no/merge.jsonl --temperature 0 --conv-mode vicuna_v1"

    if [ "$overwrite" = "True" ]; then
        python_cmd="$python_cmd --overwrite"
    fi

    $python_cmd
fi



python llava/eval/lave_metric.py  plot_calibration_curve \
      --gt_data ${question_file} \
      --model_id models/Mistral/Mistral-7B-Instruct-v0.2 \
      --pred_data ${pred_data}  \
      --pred_prob_file ${MODEL_PATH}/${DATASET}/pred_probs_only_yes_or_no/merge.jsonl  
